/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2216;

import ibm.nways.jdm.CompStatusDefault;
import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.Status;
import ibm.nways.jdm2216.GraphicActionToggleView;
import ibm.nways.jdm2216.GraphicImage2216;
import ibm.nways.jdm2216.GraphicImageModule;
import ibm.nways.jdm2216.GraphicImageModuleImpl;
import ibm.nways.jdm2216.ToggleViewImage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public abstract class AggregateAdapterImage
extends GraphicImageModuleImpl
implements ToggleViewImage,
ActionListener {
    CompoundStatus compStatus = new CompoundStatus();
    CompStatusDefault statusManager = new CompStatusDefault();
    GraphicImageModule logicalView;
    GraphicImageModule aggregateView;
    boolean aggregateDisplayed = true;
    private static ResourceBundle myResources = null;
    MenuItem aggregateMenuItem;
    MenuItem aggregateMenuItem2;
    MenuItem logicalMenuItem;

    public AggregateAdapterImage() {
        this.compStatus.setManager(this.statusManager);
        this.aggregateView = new GraphicImageModuleImpl();
        this.setModuleCount(2);
        this.setModule(1, this.aggregateView);
        this.showCurrent();
    }

    public void setLogicalView(GraphicImageModule graphicImageModule) {
        this.logicalView = graphicImageModule;
        if (this.logicalView != null) {
            this.logicalView.setAction(new GraphicActionToggleView(this));
            this.aggregateView.setAction(new GraphicActionToggleView(this));
            ((Component)((Object)this.logicalView)).setVisible(false);
            this.putInMenuItems();
        } else {
            this.aggregateView.setAction(null);
            this.removeMenuItems();
        }
        super.setModule(2, this.logicalView);
    }

    public GraphicImageModule getLogicalView() {
        return this.logicalView;
    }

    public void setAggregateView(GraphicImageModule graphicImageModule) {
        this.aggregateView = graphicImageModule;
        if (this.logicalView != null) {
            this.logicalView.setAction(new GraphicActionToggleView(this));
            this.aggregateView.setAction(new GraphicActionToggleView(this));
            this.putInMenuItems();
        } else {
            this.removeMenuItems();
        }
        super.setModule(1, this.aggregateView);
        ((Component)((Object)this)).setSize(this.aggregateView.getPreferredSize());
        this.showCurrent();
    }

    public GraphicImageModule getAggregateView() {
        return this.aggregateView;
    }

    public void setStatus(int n, Status status) {
        if (n > this.logicalView.getModuleCount()) {
            this.setLogicalView(null);
        }
        if (this.logicalView != null && this.logicalView.getModule(n) != null) {
            if (this.logicalView.getStatus(n) != null) {
                this.compStatus.removeDependent(this.logicalView.getStatus(n));
            }
            this.logicalView.setStatus(n, status);
        }
        this.compStatus.addDependent(status);
        this.aggregateView.setStatus(1, this.compStatus);
    }

    public Status getStatus(int n) {
        if (this.logicalView != null) {
            return this.logicalView.getStatus(n);
        }
        return null;
    }

    public Status getStatus() {
        return this.compStatus;
    }

    public void setAction(int n, GraphicAction graphicAction) {
        if (this.logicalView != null) {
            this.logicalView.setAction(n, graphicAction);
        }
    }

    public void setFlyOver(int n, GraphicFlyOver graphicFlyOver) {
        if (this.logicalView != null) {
            this.logicalView.setFlyOver(n, graphicFlyOver);
        }
    }

    public void toggleView() {
        this.aggregateDisplayed = !this.aggregateDisplayed;
        this.showCurrent();
    }

    public void showCurrent() {
        if (this.logicalView == null) {
            ((Component)((Object)this.aggregateView)).setVisible(true);
            return;
        }
        ((Component)((Object)this.aggregateView)).setVisible(this.aggregateDisplayed);
        ((Component)((Object)this.logicalView)).setVisible(!this.aggregateDisplayed);
    }

    public void putInMenuItems() {
        if (this.aggregateMenuItem == null) {
            this.aggregateMenuItem = new MenuItem(AggregateAdapterImage.messageText("Show Logical View"));
            this.aggregateMenuItem.addActionListener(this);
        }
        this.aggregateView.addMenuItem(this.aggregateMenuItem);
        if (this.aggregateView.getModuleCount() == 1) {
            if (this.aggregateMenuItem2 == null) {
                this.aggregateMenuItem2 = new MenuItem(AggregateAdapterImage.messageText("Show Logical View"));
                this.aggregateMenuItem2.addActionListener(this);
            }
            this.aggregateView.addMenuItem(1, this.aggregateMenuItem2);
        }
        if (this.logicalMenuItem == null) {
            this.logicalMenuItem = new MenuItem(AggregateAdapterImage.messageText("Show Aggregate View"));
            this.logicalMenuItem.addActionListener(this);
        }
        this.logicalView.addMenuItem(this.logicalMenuItem);
    }

    public void removeMenuItems() {
        if (this.aggregateView != null && this.aggregateMenuItem != null) {
            this.aggregateView.removeMenuItem(this.aggregateMenuItem);
        }
        if (this.aggregateView != null && this.aggregateMenuItem != null && this.aggregateView.getModuleCount() == 1) {
            this.aggregateView.removeMenuItem(this.aggregateMenuItem2);
        }
        if (this.logicalView != null && this.logicalMenuItem != null) {
            this.logicalView.removeMenuItem(this.logicalMenuItem);
        }
    }

    protected static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm2216.Resources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleView();
    }

    public void setModuleCount(int n) {
        if (this.logicalView != null) {
            this.logicalView.setModuleCount(n);
        }
    }

    public int getModuleCount() {
        if (this.logicalView != null) {
            return this.logicalView.getModuleCount();
        }
        return 0;
    }

    public void setModule(int n, GraphicImage2216 graphicImage2216) {
        if (this.logicalView != null) {
            this.logicalView.setModule(n, graphicImage2216);
        }
        this.setStatus(graphicImage2216.getStatus());
    }

    public GraphicImage2216 getModule(int n) {
        if (this.logicalView != null) {
            return this.logicalView.getModule(n);
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return this.aggregateView.getPreferredSize();
    }

    public void dispose() {
        int n = 0;
        while (n < this.logicalView.getModuleCount()) {
            Status status = this.logicalView.getStatus(n);
            if (status != null) {
                this.compStatus.removeDependent(status);
            }
            ++n;
        }
        super.dispose();
    }
}

